%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      Simulate6.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% Description:    This runs the project for 6 sensor colors
%-------------------------------------------------------------------------------

close all; clc;
NumRuns = 100;

% Note, this file assumes that there is already a SensorData6.mat file which
% contains all the different sensor parameters that are to be simulated

disp('Running project for 6 color sensor:');
disp('--------------------------------------');

% Define the number of sensors
numSensors = 6;

% Define Analysis Types
kMacBethAnalysis = 1;
kMTFAnalysis = 2;

% Repeat this for the Macbeth and Slanted bar scenes
while(analysisIndex <= kMTFAnalysis)
      
  % Reset the state of the random number generator
  rand('state',0)

  % Initialize the project settings
  InitializeProject;
 
  % Define the Scene
  switch analysisIndex
     case {kMacBethAnalysis}
        disp('Analyzing Color Accuracy');
        DefineMacBethScene;
    case {kMTFAnalysis}
        disp('Analyzing MTF');
        DefineMTFScene;
     otherwise
        disp('Unknown scene');
  end

  % Define the Optics
  DefineOptics;
  
  % Load in the sensor settings
  load SensorData6.mat;
  NumSimulations = size(sensorSettings,1);
  
  % Store the names of the columns in the results array so that we can
  % interpret the data
  ResultNames = sensorSettings_Names;
  
  save('Simulate6Data.mat','oi','scene','analysisIndex', 'numSensors', ...
       'kMacBethAnalysis', 'kMTFAnalysis', 'NumSimulations', 'NumRuns');  
  
  % Run through all the different sensor settings
  while(sensorIndex <= NumSimulations)
      InitializeProject;
      vcReplaceAndSelectObject(scene);
      vcReplaceAndSelectObject(oi);
      
      % Create the Image Sensor
      sensorPos = sensorSettings(sensorIndex,numSensors+1:end);
      sensorWidth = sensorSettings(sensorIndex,1:numSensors);
      CreateSensorGauss;

      % Perform Post-Processing
      ProcessImage;
      
      % Clear the screen
      clc;
      
      % Perform Analysis of Data Collected
      switch analysisIndex
         case {kMacBethAnalysis}
            MacBethAnalysis;
            colorMetrics(sensorIndex) = deltaE_avg;
            noiseMetrics(sensorIndex) = yNoise_avg;
            disp(sprintf('%d Color MacbethAnalysis: %d of %d',numSensors,sensorIndex,NumSimulations));
      	 case {kMTFAnalysis}
            MTFAnalysis;
            frequencyMetrics(sensorIndex) = results.mtf50;
            disp(sprintf('%d Color MTFAnalysis: %d of %d',numSensors,sensorIndex,NumSimulations));
          otherwise
            disp('Unknown analysis');
      end 

      
      if (mod(sensorIndex, NumRuns) == 0),
          % Clear everything and start fresh
          save('SavedData6.mat', 'colorMetrics','noiseMetrics','frequencyMetrics','analysisIndex');
          save('Simulate6_sensorIndex.mat', 'sensorIndex');

          close all;    clear all;
          load Simulate6Data.mat;
          load Simulate6_sensorIndex.mat;
          load SavedData6;
          load SensorData6.mat;
      end
      
      sensorIndex = sensorIndex + 1;
  end
  
  disp('---------------------------------------------------------------------')
   
  sensorIndex = 1;
  analysisIndex = analysisIndex + 1;
end

% End of File
